package jp.mosp.workflow.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.MosPWorkflowAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.CtWorkflowDto;
import jp.mosp.common.part.DatePart;
import jp.mosp.common.part.KintaiApprovalPart;
import jp.mosp.common.part.WorkflowPart;

import jp.mosp.human.dto.MKihonDto;

import jp.mosp.workflow.dto.CtOvertimeRequestDto;
import jp.mosp.workflow.vo.OverTimeApprovalCardVo;

public class OverTimeApprovalCardAction extends MosPWorkflowAction {

	// R}h
	public  static final String CMD_CARD_SELECT 		= "K2136";
	private static final String CMD_CARD_APPROVED 	= "K2137";
	private static final String CMD_CARD_RETURNED 	= "K2138";

	/**
	 * RXgN^
	 */
	public OverTimeApprovalCardAction() {
		super();
	}

	public void action() throws Exception {
		// VO
		OverTimeApprovalCardVo vo = new OverTimeApprovalCardVo(cfg, msg, nam, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DTO̎擾
		CtOvertimeRequestDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof CtOvertimeRequestDto ? (CtOvertimeRequestDto)obj : null;
		// [U̎擾
		getInfo(user.getUserId());
		// R}h̏
		if (cmd.equals(CMD_CARD_SELECT)) {
			// \(L[ŏ)
			// f[^̎擾
			dto = getOverTimeRequest(vo.getIntParam(key2));
			chkExist(dto);
			// VOɏZbg
			vo.setFields(dto);
			// F󋵂̐ݒ
			setApprovalStatus(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_CARD_APPROVED)) {
			// F
			approved(vo, dto);
			// F󋵂̐ݒ
			setApprovalStatus(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_CARD_RETURNED)) {
			vo.setParams(request);
			// 
			dto = returned(vo, dto);
			// F󋵂̐ݒ
			setApprovalStatus(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * F
	 * @param vo			ΏVO
	 * @param dto			ΏDTO
	 * @throws Exception
	 */
	private void approved(OverTimeApprovalCardVo vo, CtOvertimeRequestDto dto) throws Exception {
		// cƐ\F
		if (runOverTimeRequestApproved(dto, vo)) {
			// R~bg
			commit();
			// bZ[W̕\
			vo.setMessage(MospUtility.getMessage(msg, CommonConst.MSG_CODE_WORKFLOW_UPDATE, ""));
		}
	}

	/**
	 * ߏ
	 * @param vo		ΏVO
	 * @param dto		ΏDTO
	 * @return
	 * @throws Exception 
	 * @throws MospException 
	 */
	private CtOvertimeRequestDto returned(OverTimeApprovalCardVo vo, CtOvertimeRequestDto dto) throws MospException, Exception {
		// p[^̑ÓmF
		vo.validate();
		// [Nt[擾
		CtWorkflowDto workflowDto = workflowDao().findForUpdate(dto.getWorkflow());
		// F[g擾
		String[] aryRouteInfo = getTargetRouteInfo(dto.getKCode(), dto.getWorkDate());
		// ߂tO
		boolean canReturn = false;
		// ꎟ
		if (workflowDto.getLayerNumber() == CommonConst.NUM_REQUEST_LAYER) {
			if (isApprover(aryRouteInfo[0], dto.getWorkDate())) {
				if (isStatusRequest(dto.getWorkflow())) {
					workflowDto.setCurrentStatus(WorkflowPart.getStatusCodeArray()[2]);
					workflowDto.setLayerNumber(CommonConst.NUM_LAYER1);
					canReturn = true;
				}
			} else {
				StringBuffer sb = new StringBuffer();
				sb.append(DatePart.convDateToFormatDateJP(dto.getWorkDate()));
				sb.append(CommonConst.STR_UNDER_SEPARATOR);
				sb.append(CommonConst.NAM_OVER_TIME_REQUEST);
				vo.addErrMessage(MospUtility.getMessage(
						msg,
						CommonConst.MSG_CODE_DENY_APPROVAL,
						sb.toString())
				);
			}
		} 
		// 񎟍
		else if (workflowDto.getLayerNumber() == CommonConst.NUM_LAYER1) {
			if (isApprover(aryRouteInfo[1], dto.getWorkDate())) {
				if (isStatusApproved(dto.getWorkflow())) {
					workflowDto.setCurrentStatus(WorkflowPart.getStatusCodeArray()[2]);
					workflowDto.setLayerNumber(CommonConst.NUM_LAST_LAYER);
					canReturn = true;
				}
			} else {
				StringBuffer sb = new StringBuffer();
				sb.append(DatePart.convDateToFormatDateJP(dto.getWorkDate()));
				sb.append(CommonConst.STR_UNDER_SEPARATOR);
				sb.append(CommonConst.NAM_OVER_TIME_REQUEST);
				vo.addErrMessage(MospUtility.getMessage(
						msg,
						CommonConst.MSG_CODE_DENY_APPROVAL,
						sb.toString())
				);
			}
		} else {
			if (isStatusApproved(dto.getWorkflow())) {
				StringBuffer sb = new StringBuffer();
				sb.append(DatePart.convDateToFormatDateJP(dto.getWorkDate()));
				sb.append(CommonConst.MSG_OF);
				sb.append(CommonConst.NAM_OVER_TIME_REQUEST);
				// G[bZ[W
				vo.addErrMessage(MospUtility.getMessage(msg, 
						CommonConst.MSG_CODE_SELECT_ALREADY_APPROVED,
						sb.toString())
				);
			}
		}
		// ߂̏ꍇ
		if (isStatusReturned(dto.getWorkflow())) {
			StringBuffer sb = new StringBuffer();
			sb.append(DatePart.convDateToFormatDateJP(dto.getWorkDate()));
			sb.append(CommonConst.MSG_OF);
			sb.append(CommonConst.NAM_OVER_TIME_REQUEST);
			// G[bZ[W
			vo.addErrMessage(MospUtility.getMessage(msg, 
					CommonConst.MSG_CODE_SELECT_ALREADY_RETURNED,
					sb.toString())
			);
		}
		if (canReturn) {
			// [Nt[̍XV
			workflowDao().update(workflowDto);
			chkUpdate(workflowDao().findForKey(workflowDto.getWorkflow()));
			// ߂Rg̓o^
			registComment(workflowDto.getWorkflow(), mKihon.getKCode(), dto.getKCode(), vo.getTxtComment());
			// R~bg
			commit();
			// bZ[W̕\
			vo.setMessage(MospUtility.getMessage(msg, CommonConst.MSG_CODE_WORKFLOW_UPDATE, ""));
		}
		return dto;
	}

	/**
	 * F󋵏̐ݒ
	 * @param vo			ΏVO
	 * @param dto			ΏDTO
	 * @throws Exception
	 */
	private void setApprovalStatus(
			OverTimeApprovalCardVo vo,
			CtOvertimeRequestDto dto
	) throws Exception {
		MKihonDto mKihonDto = getBasisInfo(dto.getKCode());
		vo.setLblKCode(mKihonDto.getKCode());
		vo.setLblKName(mKihonDto.getSimei());
		vo.setLblSectionName(getSectionName(mKihonDto.getSCode()));
		String statusCode = toKintaiApprovalStatus(dto.getWorkflow());
		vo.setLblApprovalStatus(getApprovalName(statusCode));
		// [hݒ
		if (KintaiApprovalPart.is1stApproved(statusCode)) {
			vo.setMode(OverTimeApprovalCardVo.MODE_APPROVED);
		} else if (KintaiApprovalPart.is1stReturned(statusCode)
				|| KintaiApprovalPart.is2ndApproved(statusCode)
				|| KintaiApprovalPart.is2ndReturned(statusCode)
		) {
			vo.setMode(OverTimeApprovalCardVo.MODE_VIEW);
		}
		// ߂Rgꗗ
		setReturnedComment(vo, dto.getKCode(), dto.getWorkflow());
	}

}
